local assets=
{
	Asset("ANIM", "anim/globalsingularity.zip"),
	Asset("IMAGE", "images/globalsingularity.tex"),
	Asset("ATLAS", "images/globalsingularity.xml"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    --inst.AnimState:SetBank("manrabbit_tail")
	inst.AnimState:SetBank("globalsingularity")
    inst.AnimState:SetBuild("globalsingularity")
    inst.AnimState:PlayAnimation("idle",true)
    MakeInventoryPhysics(inst)
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    
	MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    

	--inst:AddComponent("tradable")    
	--inst.components.tradable.goldvalue = TUNING.GOLD_VALUES.MEAT*2
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "globalsingularity"
    inst.components.inventoryitem.atlasname = "images/globalsingularity.xml"
    inst.components.inventoryitem:GetImage()
    inst.components.inventoryitem:GetAtlas()
    
    --inst:AddComponent("edible")
    --inst.components.edible.foodtype = "HORRIBLE"
    

    return inst
end

return 	Prefab( "common/inventory/globalsingularity", fn, assets)
		--MakePlacer("common/prefab/resurrectionstone_placer", "resurrection_stone", "resurrection_stone", "resurrectionstone_used")

